---
title: Gateway analytics (DNS, HTTP, network sessions) · Cloudflare One docs
description: "Gateway analytics include three separate dashboards:"
lastUpdated: 2025-10-30T12:11:26.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/insights/analytics/gateway/
  md: https://developers.cloudflare.com/cloudflare-one/insights/analytics/gateway/index.md
---

Gateway analytics include three separate dashboards:

* HTTP request analytics.
* DNS query analytics.
* Network session analytics.

To review Gateway analytics:

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Insights**.
2. Go to **Dashboards**.
3. Select your desired dashboard.

## HTTP request analytics

The HTTP request analytics dashboard is powered by your [Gateway HTTP policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/). If you are not using Gateway HTTP policies, the dashboard will appear empty.

The HTTP request analytics dashboard helps you identify trends in how your HTTP policies are applied over time. By visualizing allowed, isolated, and do not inspect requests, the dashboard provides insights into traffic behavior and policy trends, making it easier to spot anomalies or shifts in usage patterns.

To review a detailed description of an HTTP request and its associated policy:

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Insights**.
2. Select **Logs**.
3. Select **HTTP request logs**.
4. Use the **Policy** filter to view HTTP requests that triggered a policy or other filters to narrow down your results.

### Provided analytics

* HTTP Requests over time
  * Time series view of HTTP requests
* Top Actions
* Top Countries
* Top Blocked Users
* Top Bandwidth Consumers
* Top Devices
* Top Source IPs

## DNS query analytics

The DNS query analytics dashboard is powered by your [Gateway DNS policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/dns-policies/). If you are not using Gateway DNS policies, the dashboard will appear empty.

The DNS query analytics dashboard helps you identify trends in how your DNS policies are applied over time. By visualizing allowed, blocked, and overridden queries, the dashboard provides insights into traffic behavior and policy trends, making it easier to spot anomalies or shifts in usage patterns.

To review a detailed description of a DNS query and its associated policy:

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Insights**.
2. Select **Logs**.
3. Select **DNS query logs**.
4. Use the **Policy** filter to view DNS queries that triggered a policy or other filters to narrow down your results.

### Provided analytics

* DNS Queries over time
  * Time series view of DNS queries
* Top Actions
* Top Countries
* Top Blocked Users
* Top Allowed Users
* Top Blocked Devices

## Network session analytics

The Network session analytics dashboard is powered by your [Gateway network policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/network-policies/). If you are not using Gateway network policies, the dashboard will appear empty.

The Network session analytics dashboard helps you identify trends in how your network policies are applied over time. By visualizing allowed, blocked, and overridden sessions, the dashboard provides insights into traffic behavior and policy trends, making it easier to spot anomalies or shifts in usage patterns.

To review a detailed description of a network session and its associated policy:

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Insights**.
2. Select **Logs**.
3. Select **Network logs**.
4. Use the **Policy** filter to view network sessions that triggered a policy or other filters to narrow down your results.

### Provided analytics

* Network Sessions over time
  * Time series view of network sessions
* Top Actions
* Top Countries
* Top Blocked Users
* Top Bandwidth Consumers
* Top Devices
* Top Source IPs

## GraphQL queries

You can use the [GraphQL Analytics API](https://developers.cloudflare.com/analytics/graphql-api/) to query your Gateway Analytics data. Available [datasets](https://developers.cloudflare.com/analytics/graphql-api/features/data-sets/) for Gateway include:

| Dataset | Description |
| - | - |
| `gatewayL4DownstreamSessionsAdaptiveGroups` | Metrics for Gateway network sessions from user devices to the Cloudflare global network. |
| `gatewayL4UpstreamSessionsAdaptiveGroups` | Metrics for Gateway network sessions from the Cloudflare global network to user devices. |
| `gatewayL4SessionsAdaptiveGroups` | Metrics for Gateway network sessions with adaptive sampling. |
| `gatewayL7RequestsAdaptiveGroups` | Metrics for Gateway HTTP requests with adaptive sampling. |
| `gatewayResolverQueriesAdaptiveGroups` | Metrics for Gateway DNS queries with adaptive sampling. |
| `gatewayResolverByRuleExecutionPerformanceAdaptiveGroups` | Time to execute Gateway DNS policies on the Cloudflare global network. |
| `gatewayResolverByCustomResolverGroups` | Metrics for Gateway DNS queries resolved using custom resolvers. |
| `gatewayResolverByCategoryAdaptiveGroups` | Metrics for Gateway DNS queries sorted by [domain category](https://developers.cloudflare.com/cloudflare-one/traffic-policies/domain-categories/) with adaptive sampling. |

To explore the schema, you can use a GraphQL client such as [GraphiQL](https://github.com/graphql/graphiql/tree/main/packages/graphiql#readme) or [Altair](https://altairgraphql.dev/).

1. [Create an API token](https://developers.cloudflare.com/analytics/graphql-api/getting-started/authentication/api-token-auth/) with the following permissions:

   | Type | Item | Permission |
   | - | - | - |
   | Account | Account Analytics | Read |

2. In your GraphQL client, [add your API token](https://developers.cloudflare.com/analytics/graphql-api/getting-started/authentication/graphql-client-headers/) as an Authorization header.

3. Compose a query to access your Gateway Analytics datasets. For example, you can query the `gatewayResolverQueriesAdaptiveGroups` dataset to return the adaptive groups of DNS queries resolved by Gateway:

   ```graphql
   query GatewaySampleQuery($accountTag: string!, $start: Time) {
     viewer {
       accounts(filter: { accountTag: $accountTag }) {
         gatewayResolverQueriesAdaptiveGroups(
           filter: { datetime_gt: $start }
           limit: 10
         ) {
           count
           dimensions {
             queryNameReversed
             resolverDecision
           }
         }
       }
     }
   }
   ```

   [Run in GraphQL API Explorer](https://graphql.cloudflare.com/explorer?query=I4VwpgTgngBA4gQwC5gO4KgZQQWwA4A2YAiuNABQAkCAxjQPYgB2SAKggOYBcMAzkhACWTDgEIANDEr8EEJD1aCcYAJQwA3gCgYMAG6C0kDdp0xaDZkl7kAZoIIoIPdWbqMW7blPPu2nGAC+alqmphzIaBgASmC89AS6kKSQBrwAggAmCHhIgolwEIx41iahOnYOkM4wWSi5ygD6HPJSMnKBpWUESoItAIwADJ06wcOmFixjOhlKYEy8gvTzxmVloJBQAHK4YDGJELxgGVOmELHx+wAiYDSCC0snAWNPoS8dAUA\&variables=N4IghgxhD2CuB2AXAKmA5iAXCAggYTwHkBVAOWQH0BJAERABoQBnRMAJ0SxACYAGbgKwBaAIwihvAchEBmTNwBsmACwB2AFogAvkA)

For more information, refer to [Compose a query in GraphiQL](https://developers.cloudflare.com/analytics/graphql-api/getting-started/compose-graphql-query/).
