---
title: Tutorials · Cloudflare Pages docs
description: View tutorials to help you get started with Pages.
lastUpdated: 2025-08-18T14:27:42.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/pages/tutorials/
  md: https://developers.cloudflare.com/pages/tutorials/index.md
---

View tutorials to help you get started with Pages.

## Docs

| Name | Last Updated | Type | Difficulty |
| - | - | - | - |
| [Point to Pages with a custom domain](https://developers.cloudflare.com/rules/origin-rules/tutorials/point-to-pages-with-custom-domain/) | 7 months ago | 📝 Tutorial | Beginner |
| [Migrating from Vercel to Pages](https://developers.cloudflare.com/pages/migrations/migrating-from-vercel/) | 7 months ago | 📝 Tutorial | Beginner |
| [Build an API for your front end using Pages Functions](https://developers.cloudflare.com/pages/tutorials/build-an-api-with-pages-functions/) | about 1 year ago | 📝 Tutorial | Intermediate |
| [Use R2 as static asset storage with Cloudflare Pages](https://developers.cloudflare.com/pages/tutorials/use-r2-as-static-asset-storage-for-pages/) | over 1 year ago | 📝 Tutorial | Intermediate |
| [Use Pages as an origin for Load Balancing](https://developers.cloudflare.com/load-balancing/pools/cloudflare-pages-origin/) | over 1 year ago | 📝 Tutorial | Beginner |
| [Localize a website with HTMLRewriter](https://developers.cloudflare.com/pages/tutorials/localize-a-website/) | over 1 year ago | 📝 Tutorial | Intermediate |
| [Build a Staff Directory Application](https://developers.cloudflare.com/d1/tutorials/build-a-staff-directory-app/) | over 1 year ago | 📝 Tutorial | Intermediate |
| [Deploy a static WordPress site](https://developers.cloudflare.com/pages/how-to/deploy-a-wordpress-site/) | over 2 years ago | 📝 Tutorial | Intermediate |
| [Build a blog using Nuxt.js and Sanity.io on Cloudflare Pages](https://developers.cloudflare.com/pages/tutorials/build-a-blog-using-nuxt-and-sanity/) | over 3 years ago | 📝 Tutorial | Intermediate |
| [Create a HTML form](https://developers.cloudflare.com/pages/tutorials/forms/) | over 3 years ago | 📝 Tutorial | Beginner |
| [Migrating from Netlify to Pages](https://developers.cloudflare.com/pages/migrations/migrating-from-netlify/) | over 3 years ago | 📝 Tutorial | Beginner |
| [Add an HTML form with Formspree](https://developers.cloudflare.com/pages/tutorials/add-an-html-form-with-formspree/) | almost 4 years ago | 📝 Tutorial | Beginner |
| [Add a React form with Formspree](https://developers.cloudflare.com/pages/tutorials/add-a-react-form-with-formspree/) | almost 4 years ago | 📝 Tutorial | Beginner |
| [Migrating a Jekyll-based site from GitHub Pages](https://developers.cloudflare.com/pages/migrations/migrating-jekyll-from-github-pages/) | over 4 years ago | 📝 Tutorial | Beginner |
| [Migrating from Firebase](https://developers.cloudflare.com/pages/migrations/migrating-from-firebase/) | about 5 years ago | 📝 Tutorial | Beginner |
| [Migrating from Workers Sites to Pages](https://developers.cloudflare.com/pages/migrations/migrating-from-workers/) | about 5 years ago | 📝 Tutorial | Beginner |

## Videos

OpenAI Relay Server on Cloudflare Workers

In this video, Craig Dennis walks you through the deployment of OpenAI's relay server to use with their realtime API.

Deploy your React App to Cloudflare Workers

Learn how to deploy an existing React application to Cloudflare Workers.

Cloudflare Workflows | Schedule and Sleep For Your Apps (Part 3 of 3)

Cloudflare Workflows allows you to initiate sleep as an explicit step, which can be useful when you want a Workflow to wait, schedule work ahead, or pause until an input or other external state is ready.
