---
title: HTTP/2 to Origin · Cloudflare Speed docs
description: A protocol is a set of rules governing the exchange or transmission
  of data between devices. One of the most important protocols that run on the
  human-computer interaction layer, where applications can access the network
  services, is HTTP (Hypertext Transfer Protocol).
lastUpdated: 2025-10-27T14:58:19.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/speed/optimization/protocol/http2-to-origin/
  md: https://developers.cloudflare.com/speed/optimization/protocol/http2-to-origin/index.md
---

A protocol is a set of rules governing the exchange or transmission of data between devices. One of the most important protocols that run on the human-computer interaction layer, where applications can access the network services, is HTTP (Hypertext Transfer Protocol).

HTTP is a well established protocol that has several versions, and each version adds features that improve performance over the older one. HTTP/1.1 and HTTP/2 are widely deployed on the Internet today. HTTP/1.1 has been around for more than a decade, but in 2015 the IETF (Internet Engineering Task Force) introduced HTTP/2, which introduces several features to reduce page load times. To know more about the differences between HTTP/1.1 and HTTP/2, please refer to [HTTP/2 versus HTTP/1.1](https://www.cloudflare.com/learning/performance/http2-vs-http1.1/).

## Availability

| | Free | Pro | Business | Enterprise |
| - | - | - | - | - |
| Availability | Yes | Yes | Yes | Yes |

## Disable HTTP/2 to Origin

At Cloudflare, HTTP/2 connection to the origin is enabled by default.

If you wish to disable HTTP/2 to Origin, you can follow these steps:

1. In the Cloudflare dashboard, go to the **Speed** > **Settings** page.

   [Go to **Settings**](https://dash.cloudflare.com/?to=/:account/:zone/speed/optimization)

2. Go to the **Protocol Optimization** tab and under **HTTP/2 to Origin** set the toggle to **Off**.

## Connection multiplexing

Cloudflare’s HTTP/2 multiplexing to origin reduces active connections by pooling many requests into fewer TCP connections. If a request arrives and the current connection has not reached the stream limit, Cloudflare reuses the existing connection. If the limit has not been reached, Cloudflare may open additional connections to handle more requests. Because multiplexing reuses fewer TCP connections, the overall number of active connections to your origin will typically be lower, which is often helpful for systems sensitive to connection overhead. During surges (like failovers), Cloudflare scales connections by first using available streams, then opening new ones as needed.

### Configuration

Connection multiplexing is enabled by default on Free, Pro and Business zones and uses up to 100 concurrent streams by default. Enterprise plans can explicitly configure the maximum number of concurrent streams (often called the “multiplexing ratio”) for a zone in the dashboard or via API.

Dashboard

1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/login) and select your account.
2. Choose the domain that will use HTTP/2 to Origin.
3. Select **Speed > Optimization**.
4. Open the **Protocol Optimization** tab.
5. Under **HTTP/2 to Origin**, select **Configure** and adjust the stream settings as needed.

API

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `Zone Settings Write`
* `Zone Write`

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/settings/origin_h2_max_streams" \
  --request PATCH \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
  --json '{
    "value": 100
  }'
```

Refer to the [API documentation](https://developers.cloudflare.com/api/python/resources/zones/subresources/settings/methods/edit/) for more information.

Note

If your origin does not support multiplexing, enabling HTTP/2 to origin may result in 5xx errors, particularly 520s.

During the HTTP/2 handshake, our edge reads the SETTINGS\_MAX\_CONCURRENT\_STREAMS that your origin advertises, and it will respect that lower limit if your origin is configured with a stricter concurrency cap than Cloudflare’s setting. This allows you to control concurrency on a per-origin basis, while still benefiting from Cloudflare’s multiplexing framework.

## Protocol compatibility

Note that if the origin does not support HTTP/2, Cloudflare will initiate an HTTP/1.1 connection. We connect to servers who announce support of HTTP/2 connections via [ALPN](https://blog.cloudflare.com/introducing-http2).

If you are unsure if your server supports HTTP/2, we suggest checking your origin server’s documentation or using a testing tool for HTTP/2 implementation (for example, [h2spec](https://github.com/summerwind/h2spec)).
